<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserSkills extends Model 
{

    protected $table = 'user_skills';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'skill_id', 'capacity', 'is_secondary');
    protected $visible = array('user_id', 'skill_id', 'capacity', 'is_secondary');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function skill()
    {
        return $this->belongsTo('App\Models\Skill', 'skill_id');
    }

}